/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lekavar.lma.drinkbeer.managers.MixedBeerManager;
import lekavar.lma.drinkbeer.utils.mixedbeer.FlavorCombinations;
import lekavar.lma.drinkbeer.utils.mixedbeer.Flavors;
import lekavar.lma.drinkbeer.utils.mixedbeer.MixedBeerOnUsing;
import lekavar.lma.drinkbeer.utils.mixedbeer.Spices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class SpiceAndFlavorManager {
    public static String getSpiceToolTipTranslationKey() {
        return "item.drinkbeer.spice.tooltip";
    }

    public static String getNoFlavorToolTipTranslationKey() {
        return "item.drinkbeer.spice.tooltip_no_flavor";
    }

    public static String getFlavorToolTipTranslationKey() {
        return "item.drinkbeer.spice.tooltip_flavor";
    }

    public static String getFlavorTranslationKey(int flavorId) {
        return SpiceAndFlavorManager.getFlavorTranslationKey(Flavors.byId(flavorId));
    }

    public static String getFlavorTranslationKey(Flavors flavor) {
        return "drinkbeer.flavor." + flavor.getName();
    }

    public static String getFlavorToolTipTranslationKey(int flavorId) {
        return SpiceAndFlavorManager.getFlavorTranslationKey(flavorId) + ".tooltip";
    }

    public static SimpleParticleType getLastSpiceFlavorParticle(List<Integer> spiceList) {
        if (spiceList != null && !spiceList.isEmpty()) {
            int lastSpiceId = spiceList.get(spiceList.size() - 1);
            return Spices.byId(lastSpiceId).getFlavor().getParticle();
        }
        return (SimpleParticleType)Flavors.DEFAULT_PARTICLE;
    }

    private static List<Flavors> spiceListToFlavorList(@NotNull List<Integer> spiceList) {
        ArrayList<Flavors> flavorList = new ArrayList<Flavors>();
        if (!spiceList.isEmpty()) {
            for (int spiceId : spiceList) {
                flavorList.add(Spices.byId(spiceId).getFlavor());
            }
        }
        return flavorList;
    }

    public static Flavors getCombinedFlavor(List<Integer> spiceList) {
        FlavorCombinations flavorCombination = SpiceAndFlavorManager.matchFlavorCombination(SpiceAndFlavorManager.spiceListToFlavorList(spiceList));
        return flavorCombination != null ? flavorCombination.getCombinedFlavor() : null;
    }

    private static FlavorCombinations matchFlavorCombination(List<Flavors> flavorList) {
        if (flavorList == null) {
            return null;
        }
        for (int i = 0; i < flavorList.size(); ++i) {
            Flavors fatherFlavor = flavorList.get(i).getFatherFlavor();
            if (fatherFlavor == null) continue;
            flavorList.set(i, fatherFlavor);
        }
        for (FlavorCombinations flavorCombination : FlavorCombinations.getFlavorCombinationList()) {
            List<Pair<List<Flavors>, Boolean>> flavorCombinationList = flavorCombination.getFlavorCombination().getFlavorCombinationList();
            try {
                for (Pair<List<Flavors>, Boolean> flavorCombinationPair : flavorCombinationList) {
                    if (((Boolean)flavorCombinationPair.getValue()).booleanValue()) {
                        if (!((List)flavorCombinationPair.getKey()).equals(flavorList)) continue;
                        return flavorCombination;
                    }
                    ArrayList tempFlavorList1 = new ArrayList();
                    ArrayList tempFlavorList2 = new ArrayList();
                    Collections.copy(tempFlavorList1, flavorList);
                    Collections.copy(tempFlavorList2, (List)flavorCombinationPair.getKey());
                    Collections.sort(tempFlavorList1);
                    Collections.sort(tempFlavorList2);
                    if (!tempFlavorList1.equals(tempFlavorList2)) continue;
                    return flavorCombination;
                }
            }
            catch (Exception e) {
                System.out.println("NULL value of FlavorCombination in FlavorCombinations!");
                System.out.println("Found in " + flavorCombination.getCombinedFlavor());
            }
        }
        return null;
    }

    public static void applyFlavorValue(MixedBeerOnUsing mixedBeerOnUsing) {
        if (!mixedBeerOnUsing.getFlavorList().isEmpty()) {
            block8: for (Flavors flavor : mixedBeerOnUsing.getFlavorList()) {
                switch (flavor) {
                    case SPICY: 
                    case FIERY: {
                        SpiceAndFlavorManager.applySpicyFlavorValue(mixedBeerOnUsing, flavor);
                        continue block8;
                    }
                    case AROMATIC: 
                    case AROMATIC1: {
                        SpiceAndFlavorManager.applyAromiticFlavorValue(mixedBeerOnUsing, flavor);
                        continue block8;
                    }
                    case REFRESHING: 
                    case REFRESHING1: {
                        SpiceAndFlavorManager.applyRefreshingFlavorValue(mixedBeerOnUsing, flavor);
                        continue block8;
                    }
                    case NUTTY: 
                    case NUTTY1: {
                        SpiceAndFlavorManager.applyNuttyFlavorAction(mixedBeerOnUsing, flavor);
                        continue block8;
                    }
                    case SWEET: 
                    case CLOYING: 
                    case LUSCIOUS: {
                        SpiceAndFlavorManager.applySweetFlavorAction(mixedBeerOnUsing, flavor);
                        continue block8;
                    }
                    case MELLOW: {
                        SpiceAndFlavorManager.applyMellowFlavorAction(mixedBeerOnUsing, flavor);
                        continue block8;
                    }
                }
                mixedBeerOnUsing.addAction(flavor);
            }
        }
    }

    public static void applyFlavorAction(MixedBeerOnUsing mixedBeerOnUsing, Level world, LivingEntity user) {
        List<Flavors> actionList = mixedBeerOnUsing.getActionList();
        if (!actionList.isEmpty()) {
            block6: for (int i = 0; i < actionList.size(); ++i) {
                Flavors flavor = actionList.get(i);
                switch (flavor) {
                    case SOOOOO_SPICY: {
                        SpiceAndFlavorManager.applySoooooSpicyFlavorAction(user);
                        continue block6;
                    }
                    case STORMY: {
                        if (MixedBeerManager.hasActionAfter(i, Flavors.STORMY, mixedBeerOnUsing.getActionList()) || MixedBeerManager.hasActionAfter(i, Flavors.THE_FALL_OF_THE_GIANT, mixedBeerOnUsing.getActionList())) continue block6;
                        SpiceAndFlavorManager.applyStormyFlavorAction(MixedBeerManager.getActionedTimes(i, Flavors.STORMY, mixedBeerOnUsing.getActionList()), world, user);
                        continue block6;
                    }
                    case THE_FALL_OF_THE_GIANT: {
                        SpiceAndFlavorManager.applyStormyFlavorAction(3, world, user);
                        continue block6;
                    }
                    case DRYING: {
                        if (MixedBeerManager.hasActionAfter(i, Flavors.DRYING, mixedBeerOnUsing.getActionList())) continue block6;
                        SpiceAndFlavorManager.applyDryingFlavorAction(MixedBeerManager.getActionedTimes(i, Flavors.DRYING, mixedBeerOnUsing.getActionList()), world, user);
                    }
                }
            }
        }
    }

    public static void applySpicyFlavorValue(MixedBeerOnUsing mixedBeerOnUsing, Flavors flavor) {
        switch (flavor) {
            case SPICY: {
                mixedBeerOnUsing.addHealth(-3.0f);
                mixedBeerOnUsing.multiplyAllStatusEffectDuration(1.8f);
                break;
            }
            case FIERY: {
                mixedBeerOnUsing.addHealth(-4.0f);
                mixedBeerOnUsing.multiplyAllStatusEffectDuration(2.0f);
            }
        }
    }

    public static void applySoooooSpicyFlavorAction(LivingEntity user) {
        int fireTicks = 100;
        if (!user.m_6060_()) {
            user.m_7311_(fireTicks);
        } else {
            user.m_7311_(user.m_20094_() + fireTicks);
        }
    }

    public static void applyAromiticFlavorValue(MixedBeerOnUsing mixedBeerOnUsing, Flavors flavor) {
        switch (flavor) {
            case AROMATIC: {
                mixedBeerOnUsing.addAllStatusEffectDuration(800);
                break;
            }
            case AROMATIC1: {
                mixedBeerOnUsing.addAllStatusEffectDuration(1200);
            }
        }
    }

    public static void applyRefreshingFlavorValue(MixedBeerOnUsing mixedBeerOnUsing, Flavors flavor) {
        switch (flavor) {
            case REFRESHING: {
                mixedBeerOnUsing.addDrunkValue(-1);
                break;
            }
            case REFRESHING1: {
                mixedBeerOnUsing.addDrunkValue(-2);
            }
        }
    }

    public static void applyStormyFlavorAction(int actionedTimes, Level world, LivingEntity user) {
        int range = 9 + (actionedTimes == 3 ? 22 : actionedTimes * 4);
        int halfRange = (range - 1) / 2;
        int xStart = 0;
        int xEnd = 0;
        int zStart = 0;
        int zEnd = 0;
        Direction direction = user.m_6374_();
        switch (direction) {
            case NORTH: {
                xStart = -halfRange;
                xEnd = halfRange + 1;
                zStart = -range;
                break;
            }
            case SOUTH: {
                xStart = -halfRange;
                xEnd = halfRange + 1;
                zEnd = range;
                break;
            }
            case EAST: {
                zStart = -halfRange;
                zEnd = halfRange + 1;
                xEnd = range;
                break;
            }
            case WEST: {
                zStart = -halfRange;
                zEnd = halfRange + 1;
                xStart = -range;
            }
        }
        for (int x = xStart; x < xEnd; ++x) {
            for (int y = 0; y < range; ++y) {
                for (int z = zStart; z < zEnd; ++z) {
                    BlockPos pos = user.m_142538_().m_142082_(x, y, z);
                    BlockState blockState = world.m_8055_(pos);
                    if (!blockState.m_204336_(BlockTags.f_13106_) && !blockState.m_204336_(BlockTags.f_13035_)) continue;
                    world.m_46961_(pos, true);
                }
            }
        }
    }

    public static void applyNuttyFlavorAction(MixedBeerOnUsing mixedBeerOnUsing, Flavors flavor) {
        switch (flavor) {
            case NUTTY: {
                mixedBeerOnUsing.addHunger(4);
                break;
            }
            case NUTTY1: {
                mixedBeerOnUsing.addHunger(5);
            }
        }
    }

    public static void applySweetFlavorAction(MixedBeerOnUsing mixedBeerOnUsing, Flavors flavor) {
        switch (flavor) {
            case SWEET: {
                mixedBeerOnUsing.addHealth(3.0f);
                break;
            }
            case LUSCIOUS: {
                mixedBeerOnUsing.addHealth(4.0f);
                break;
            }
            case CLOYING: {
                mixedBeerOnUsing.addHealth(1.0f);
            }
        }
    }

    public static void applyMellowFlavorAction(MixedBeerOnUsing mixedBeerOnUsing, Flavors flavor) {
        switch (flavor) {
            case MELLOW: {
                mixedBeerOnUsing.addSpecificStatusEffectDuration(MobEffects.f_19606_, 1600);
            }
        }
    }

    public static void applyDryingFlavorAction(int actionedTimes, Level world, LivingEntity user) {
        int range = 17 + actionedTimes * 4;
        int halfRange = (range - 1) / 2;
        int xStart = 0;
        int xEnd = 0;
        int zStart = 0;
        int zEnd = 0;
        Direction direction = user.m_6374_();
        switch (direction) {
            case NORTH: {
                xStart = -halfRange;
                xEnd = halfRange + 1;
                zStart = -range;
                break;
            }
            case SOUTH: {
                xStart = -halfRange;
                xEnd = halfRange + 1;
                zEnd = range;
                break;
            }
            case EAST: {
                zStart = -halfRange;
                zEnd = halfRange + 1;
                xEnd = range;
                break;
            }
            case WEST: {
                zStart = -halfRange;
                zEnd = halfRange + 1;
                xStart = -range;
            }
        }
        for (int x = xStart; x < xEnd; ++x) {
            for (int y = 0; y < range; ++y) {
                for (int z = zStart; z < zEnd; ++z) {
                    BlockPos pos = user.m_142538_().m_142082_(x, y, z);
                    BlockState blockState = world.m_8055_(pos);
                    if (!blockState.m_60734_().equals(Blocks.f_49990_)) continue;
                    world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                }
            }
        }
    }
}

