/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.items;

import java.util.List;
import javax.annotation.Nullable;
import lekavar.lma.drinkbeer.items.BeerBlockItem;
import lekavar.lma.drinkbeer.managers.MixedBeerManager;
import lekavar.lma.drinkbeer.managers.SpiceAndFlavorManager;
import lekavar.lma.drinkbeer.utils.ModCreativeTab;
import lekavar.lma.drinkbeer.utils.beer.Beers;
import lekavar.lma.drinkbeer.utils.mixedbeer.Flavors;
import lekavar.lma.drinkbeer.utils.mixedbeer.Spices;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MixedBeerBlockItem
extends BeerBlockItem {
    public MixedBeerBlockItem(Block block) {
        super(block, new Item.Properties().m_41491_((CreativeModeTab)ModCreativeTab.BEER).m_41487_(1).m_41489_(new FoodProperties.Builder().m_38765_().m_38767_()));
    }

    public void appendMixedBeerTooltip(ItemStack stack, List<Component> tooltip) {
        tooltip.add((Component)new TranslatableComponent(MixedBeerManager.getBaseBeerToolTipTranslationKey()).m_130946_(":").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.WHITE)));
        int beerId = MixedBeerManager.getBeerId(stack);
        Item beerItem = Beers.byId(beerId).getBeerItem();
        String beerName = beerId > 0 ? "block.drinkbeer." + beerItem.toString() : MixedBeerManager.getUnmixedToolTipTranslationKey();
        String beerTooltip = beerId > 0 ? "item.drinkbeer." + beerItem.toString() + ".tooltip" : "";
        tooltip.add((Component)new TranslatableComponent(beerName).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.BLUE)));
        if (beerId > 0 && Beers.byId(beerId).getHasStatusEffectTooltip()) {
            tooltip.add((Component)new TranslatableComponent(beerTooltip).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.BLUE)));
        }
        if (beerId > 0) {
            String hunger = Integer.toString(beerItem.m_41473_().m_38744_());
            tooltip.add((Component)new TranslatableComponent("drinkbeer.restores_hunger").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.BLUE)).m_130946_(hunger));
        }
        tooltip.add((Component)new TranslatableComponent(SpiceAndFlavorManager.getFlavorToolTipTranslationKey()).m_130946_(":").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.WHITE)));
        List<Integer> spiceList = MixedBeerManager.getSpiceList(stack);
        if (!spiceList.isEmpty()) {
            for (int spiceId : spiceList) {
                Flavors flavor = Spices.byId(spiceId).getFlavor();
                tooltip.add((Component)new TranslatableComponent(SpiceAndFlavorManager.getFlavorTranslationKey(flavor.getId())).m_130946_("(").m_7220_((Component)new TranslatableComponent(SpiceAndFlavorManager.getFlavorToolTipTranslationKey(flavor.getId()))).m_130946_(")").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED)));
            }
        } else {
            tooltip.add((Component)new TranslatableComponent(SpiceAndFlavorManager.getNoFlavorToolTipTranslationKey()).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED)));
        }
        Flavors combinedFlavor = SpiceAndFlavorManager.getCombinedFlavor(spiceList);
        if (combinedFlavor != null) {
            tooltip.add((Component)new TranslatableComponent("").m_130946_("\"").m_7220_((Component)new TranslatableComponent(SpiceAndFlavorManager.getFlavorTranslationKey(combinedFlavor.getId()))).m_130946_("\"").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_RED)));
        }
    }

    public Component m_7626_(ItemStack stack) {
        return this.getMixedBeerName(stack);
    }

    public Component getMixedBeerName(ItemStack stack) {
        int beerId = MixedBeerManager.getBeerId(stack);
        Item beerItem = Beers.byId(beerId).getBeerItem();
        String beerName = beerId > 0 ? "block.drinkbeer." + beerItem.toString() : "block.drinkbeer.empty_beer_mug";
        MutableComponent name = new TranslatableComponent(beerName).m_7220_((Component)new TranslatableComponent("block.drinkbeer." + MixedBeerManager.getMixedBeerTranslationKey())).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.YELLOW));
        return name;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        if (world != null && world.m_5776_()) {
            this.appendMixedBeerTooltip(stack, tooltip);
        }
    }

    protected boolean m_7429_(BlockPlaceContext context, BlockState state) {
        return super.m_7429_(context, state);
    }

    protected boolean m_40610_(BlockPlaceContext context, BlockState state) {
        if (context.m_43720_().m_82554_(context.m_43723_().m_20182_()) > 2.0) {
            return false;
        }
        return super.m_40610_(context, state);
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity user) {
        if (!world.m_5776_()) {
            MixedBeerManager.useMixedBeer(stack, world, user);
        }
        this.giveEmptyMugBack(user);
        return super.m_5922_(stack, world, user);
    }
}

