/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.items;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lekavar.lma.drinkbeer.effects.DrunkStatusEffect;
import lekavar.lma.drinkbeer.effects.NightHowlStatusEffect;
import lekavar.lma.drinkbeer.items.BeerBlockItem;
import lekavar.lma.drinkbeer.utils.ModCreativeTab;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BeerMugItem
extends BeerBlockItem {
    private static final double MAX_PLACE_DISTANCE = 2.0;
    private final boolean hasExtraTooltip;

    public BeerMugItem(Block block, int nutrition, boolean hasExtraTooltip) {
        super(block, new Item.Properties().m_41491_((CreativeModeTab)ModCreativeTab.BEER).m_41487_(16).m_41489_(new FoodProperties.Builder().m_38760_(nutrition).m_38765_().m_38767_()));
        this.hasExtraTooltip = hasExtraTooltip;
    }

    public BeerMugItem(Block block, @Nullable MobEffectInstance statusEffectInstance, int nutrition, boolean hasExtraTooltip) {
        super(block, new Item.Properties().m_41491_((CreativeModeTab)ModCreativeTab.BEER).m_41487_(16).m_41489_(statusEffectInstance != null ? new FoodProperties.Builder().m_38760_(nutrition).m_38762_(statusEffectInstance, 1.0f).m_38765_().m_38767_() : new FoodProperties.Builder().m_38760_(nutrition).m_38765_().m_38767_()));
        this.hasExtraTooltip = hasExtraTooltip;
    }

    public BeerMugItem(Block block, Supplier<MobEffectInstance> statusEffectInstance, int nutrition, boolean hasExtraTooltip) {
        super(block, new Item.Properties().m_41491_((CreativeModeTab)ModCreativeTab.BEER).m_41487_(16).m_41489_(statusEffectInstance != null ? new FoodProperties.Builder().m_38760_(nutrition).effect(statusEffectInstance, 1.0f).m_38765_().m_38767_() : new FoodProperties.Builder().m_38760_(nutrition).m_38765_().m_38767_()));
        this.hasExtraTooltip = hasExtraTooltip;
    }

    protected boolean m_40610_(BlockPlaceContext p_195944_1_, BlockState p_195944_2_) {
        if (p_195944_1_.m_43720_().m_82554_(p_195944_1_.m_43723_().m_20182_()) > 2.0) {
            return false;
        }
        return super.m_40610_(p_195944_1_, p_195944_2_);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        String name = this.m_5456_().toString();
        if (this.hasEffectNoticeTooltip() && world != null && world.m_5776_()) {
            tooltip.add((Component)new TranslatableComponent("item.drinkbeer." + name + ".tooltip").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.BLUE)));
        }
        String hunger = String.valueOf(stack.m_41720_().m_41473_().m_38744_());
        tooltip.add((Component)new TranslatableComponent("drinkbeer.restores_hunger").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.BLUE)).m_130946_(hunger));
    }

    private boolean hasEffectNoticeTooltip() {
        return this.hasExtraTooltip;
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity user) {
        DrunkStatusEffect.addStatusEffect(user);
        NightHowlStatusEffect.addStatusEffect(stack, world, user);
        this.giveEmptyMugBack(user);
        return super.m_5922_(stack, world, user);
    }
}

