/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import lekavar.lma.drinkbeer.blocks.TradeboxBlock;
import lekavar.lma.drinkbeer.gui.TradeBoxContainer;
import lekavar.lma.drinkbeer.managers.TradeBoxManager;
import lekavar.lma.drinkbeer.networking.NetWorking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class TradeBoxContainerScreen
extends AbstractContainerScreen<TradeBoxContainer> {
    private static final ResourceLocation TRADE_BOX_GUI = new ResourceLocation("drinkbeer", "textures/gui/container/trade_box.png");
    private final int textureWidth = 176;
    private final int textureHeight = 166;
    private Inventory inventory;
    TradeBoxContainer container;

    public TradeBoxContainerScreen(TradeBoxContainer screenContainer, Inventory inv, Component title) {
        super((AbstractContainerMenu)screenContainer, inv, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.inventory = inv;
        this.container = screenContainer;
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TRADE_BOX_GUI);
        int backgroundWidth = this.getXSize();
        int backgroundHeight = this.getYSize();
        int x = (this.f_96543_ - backgroundWidth) / 2;
        int y = (this.f_96544_ - backgroundHeight) / 2;
        this.m_93228_(stack, x, y, 0, 0, backgroundWidth, backgroundHeight);
        if (this.container.isCooling()) {
            this.m_93228_(stack, x + 84, y + 25, 178, 38, 72, 36);
            String timeStr = this.convertTickToTime(this.container.getCoolingTime());
            this.f_96547_.m_92883_(stack, timeStr, (float)(x + 114), (float)(y + 39), new Color(64, 64, 64, 255).getRGB());
        } else if (this.container.isTrading()) {
            if (this.m_6774_(157, 6, 13, 13, mouseX, mouseY)) {
                this.m_93228_(stack, x + 155, y + 4, 178, 19, 16, 16);
            } else {
                this.m_93228_(stack, x + 155, y + 4, 178, 0, 16, 16);
            }
        }
        if (!this.container.isCooling()) {
            Language language = Language.m_128107_();
            String youStr = language.m_6834_("drinkbeer.resident.you");
            this.f_96547_.m_92883_(stack, youStr, (float)(x + 85), (float)(y + 16), new Color(64, 64, 64, 255).getRGB());
            String locationAndResidentStr = language.m_6834_(TradeBoxManager.getLocationTranslationKey(this.container.getLocationId())) + "-" + language.m_6834_(TradeBoxManager.getResidentTranslationKey(this.container.getResidentId()));
            this.f_96547_.m_92883_(stack, locationAndResidentStr, (float)(x + 85), (float)(y + 63), new Color(64, 64, 64, 255).getRGB());
        }
    }

    public String convertTickToTime(int tick) {
        Object result;
        if (tick > 0) {
            double time = (double)tick / 20.0;
            int m = (int)(time / 60.0);
            int s = (int)(time % 60.0);
            result = m + ":" + s;
        } else {
            result = "";
        }
        return result;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
    }

    protected boolean m_6774_(int xPosition, int yPosition, int width, int height, double pointX, double pointY) {
        return super.m_6774_(xPosition, yPosition, width, height, pointX, pointY);
    }

    protected void m_7856_() {
        int x = (this.f_96543_ - this.getXSize()) / 2;
        int y = (this.f_96544_ - this.getYSize()) / 2;
        this.m_142416_((GuiEventListener)new ImageButton(x + 156, y + 5, 15, 15, 210, 0, 0, TRADE_BOX_GUI, buttonWidget -> {
            BlockPos pos;
            if (this.container.isTrading() && (pos = this.getHitTradeBoxBlockPos()) != null) {
                NetWorking.sendRefreshTradebox(pos);
            }
        }));
        super.m_7856_();
    }

    private BlockPos getHitTradeBoxBlockPos() {
        BlockHitResult blockHit;
        BlockPos blockPos;
        BlockState blockState;
        Block block;
        Minecraft client = Minecraft.m_91087_();
        HitResult hit = client.f_91077_;
        if (hit.m_6662_().equals((Object)HitResult.Type.BLOCK) && (block = (blockState = client.f_91073_.m_8055_(blockPos = (blockHit = (BlockHitResult)hit).m_82425_())).m_60734_()) instanceof TradeboxBlock) {
            return blockPos;
        }
        return null;
    }
}

