/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.effects;

import java.util.Random;
import lekavar.lma.drinkbeer.registries.ItemRegistry;
import lekavar.lma.drinkbeer.registries.SoundEventRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class NightHowlStatusEffect {
    private static final int BASE_NIGHT_VISION_TIME = 2400;

    public static void addStatusEffect(ItemStack stack, Level world, LivingEntity user) {
        if (stack.m_41720_() == ItemRegistry.BEER_MUG_NIGHT_HOWL_KVASS.get()) {
            user.m_7292_(new MobEffectInstance(MobEffects.f_19611_, NightHowlStatusEffect.getNightVisionTime(NightHowlStatusEffect.getMoonPhase(world))));
            NightHowlStatusEffect.playRandomHowlSound(world, user);
        }
    }

    public static Pair<MobEffect, Integer> getStatusEffectPair(Level world) {
        return Pair.of((Object)MobEffects.f_19611_, (Object)NightHowlStatusEffect.getNightVisionTime(NightHowlStatusEffect.getMoonPhase(world)));
    }

    public static void playRandomHowlSound(Level world, LivingEntity user) {
        if (!world.f_46443_) {
            world.m_5594_(null, user.m_142538_(), (SoundEvent)SoundEventRegistry.NIGHT_HOWL[new Random().nextInt(4)].get(), SoundSource.PLAYERS, 1.2f, 1.0f);
        }
    }

    private static int getNightVisionTime(int moonPhase) {
        return 2400 + (moonPhase == 0 ? Math.abs(moonPhase - 1 - 4) * 1200 : Math.abs(moonPhase - 4) * 1200);
    }

    private static int getMoonPhase(Level world) {
        try {
            long timeOfDay = world.m_46468_();
            return (int)(timeOfDay / 24000L % 8L + 8L) % 8;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

