/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.blockentities;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lekavar.lma.drinkbeer.gui.BeerBarrelContainer;
import lekavar.lma.drinkbeer.recipes.BrewingRecipe;
import lekavar.lma.drinkbeer.recipes.IBrewingInventory;
import lekavar.lma.drinkbeer.registries.BlockEntityRegistry;
import lekavar.lma.drinkbeer.registries.ItemRegistry;
import lekavar.lma.drinkbeer.registries.RecipeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BeerBarrelBlockEntity
extends BaseContainerBlockEntity
implements IBrewingInventory {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
    private int remainingBrewTime;
    private int statusCode;
    public final ContainerData syncData = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return BeerBarrelBlockEntity.this.remainingBrewTime;
                }
                case 1: {
                    return BeerBarrelBlockEntity.this.statusCode;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    BeerBarrelBlockEntity.this.remainingBrewTime = value;
                    break;
                }
                case 1: {
                    BeerBarrelBlockEntity.this.statusCode = value;
                }
            }
        }

        public int m_6499_() {
            return 1;
        }
    };
    private final IItemHandler itemHandler = new IItemHandler(){

        public int getSlots() {
            return BeerBarrelBlockEntity.this.items.size();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ((ItemStack)BeerBarrelBlockEntity.this.items.get(slot)).m_41777_();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return stack;
            }
            if (stack.m_41720_() == ItemRegistry.EMPTY_BEER_MUG.get() && slot != 4) {
                return stack;
            }
            if (slot <= 3) {
                ItemStack inSlot = (ItemStack)BeerBarrelBlockEntity.this.items.get(slot);
                if (inSlot.m_41619_()) {
                    if (!simulate) {
                        BeerBarrelBlockEntity.this.items.set(slot, (Object)new ItemStack((ItemLike)stack.m_41720_(), 1));
                        BeerBarrelBlockEntity.this.m_6596_();
                    }
                    if (stack.m_41613_() == 1) {
                        return ItemStack.f_41583_;
                    }
                    return new ItemStack((ItemLike)stack.m_41720_(), stack.m_41613_() - 1);
                }
                return stack;
            }
            if (slot == 4) {
                if (stack.m_41720_() == ItemRegistry.EMPTY_BEER_MUG.get()) {
                    int totalNewCount = stack.m_41613_() + ((ItemStack)BeerBarrelBlockEntity.this.items.get(slot)).m_41613_();
                    if (!simulate) {
                        ItemStack newStack = stack.m_41777_();
                        newStack.m_41764_(totalNewCount);
                        BeerBarrelBlockEntity.this.items.set(slot, (Object)newStack);
                        BeerBarrelBlockEntity.this.m_6596_();
                    }
                    return totalNewCount <= 64 ? ItemStack.f_41583_ : new ItemStack((ItemLike)stack.m_41720_(), totalNewCount - 64);
                }
                return stack;
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 5 && BeerBarrelBlockEntity.this.statusCode != 2) {
                return ItemStack.f_41583_;
            }
            ItemStack inSlot = ((ItemStack)BeerBarrelBlockEntity.this.items.get(slot)).m_41777_();
            if (slot <= 4 && inSlot.m_41720_() != Items.f_42446_.m_7968_().m_41720_()) {
                return ItemStack.f_41583_;
            }
            if (inSlot.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (amount > inSlot.m_41741_()) {
                amount = inSlot.m_41741_();
            }
            if (amount > inSlot.m_41613_()) {
                amount = inSlot.m_41613_();
            }
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            if (!simulate) {
                if (amount == inSlot.m_41613_()) {
                    BeerBarrelBlockEntity.this.items.set(slot, (Object)ItemStack.f_41583_);
                    BeerBarrelBlockEntity.this.m_6596_();
                    return inSlot;
                }
                ItemStack newStack = inSlot.m_41777_();
                newStack.m_41764_(amount);
                BeerBarrelBlockEntity.this.items.set(slot, (Object)new ItemStack((ItemLike)inSlot.m_41720_(), inSlot.m_41613_() - amount));
                BeerBarrelBlockEntity.this.m_6596_();
                return newStack;
            }
            if (amount == inSlot.m_41613_()) {
                return inSlot.m_41777_();
            }
            return new ItemStack((ItemLike)inSlot.m_41720_(), amount);
        }

        public int getSlotLimit(int slot) {
            if (slot <= 3) {
                return 1;
            }
            if (slot == 4) {
                return 64;
            }
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (stack.m_41720_() == ItemRegistry.EMPTY_BEER_MUG.get() && slot != 4) {
                return false;
            }
            if (slot == 4) {
                return stack.m_41720_() == ItemRegistry.EMPTY_BEER_MUG.get();
            }
            return slot != 5;
        }
    };

    public BeerBarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.BEER_BARREL_TILEENTITY.get(), pos, state);
    }

    public void tickServer() {
        if (this.statusCode == 0) {
            if (!this.getIngredients().contains(ItemStack.f_41583_)) {
                BrewingRecipe recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)RecipeRegistry.RECIPE_TYPE_BREWING.get(), (Container)this, this.f_58857_).orElse(null);
                if (this.canBrew(recipe)) {
                    this.showPreview(recipe);
                    if (this.hasEnoughEmptyCap(recipe)) {
                        this.startBrewing(recipe);
                    }
                } else {
                    this.clearPreview();
                }
            } else {
                this.clearPreview();
            }
        } else if (this.statusCode == 1) {
            if (this.remainingBrewTime > 0) {
                --this.remainingBrewTime;
            } else {
                this.remainingBrewTime = 0;
                this.statusCode = 2;
            }
            this.m_6596_();
        } else if (this.statusCode == 2) {
            if (((ItemStack)this.items.get(5)).m_41619_()) {
                this.statusCode = 0;
                this.m_6596_();
            }
        } else {
            this.remainingBrewTime = 0;
            this.statusCode = 0;
            this.m_6596_();
        }
    }

    private boolean canBrew(@Nullable BrewingRecipe recipe) {
        if (recipe != null) {
            return recipe.matches(this, this.f_58857_);
        }
        return false;
    }

    private boolean hasEnoughEmptyCap(BrewingRecipe recipe) {
        return recipe.isCupQualified(this);
    }

    private void startBrewing(BrewingRecipe recipe) {
        this.items.set(5, (Object)recipe.assemble(this));
        for (int i = 0; i < 4; ++i) {
            ItemStack ingred = (ItemStack)this.items.get(i);
            if (this.isBucket(ingred)) {
                this.items.set(i, (Object)Items.f_42446_.m_7968_());
                continue;
            }
            ingred.m_41774_(1);
        }
        ((ItemStack)this.items.get(4)).m_41774_(recipe.getRequiredCupCount());
        this.remainingBrewTime = recipe.getBrewingTime();
        this.statusCode = 1;
        this.m_6596_();
    }

    private boolean isBucket(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof BucketItem || itemStack.m_41720_() instanceof MilkBucketItem;
    }

    private void clearPreview() {
        this.items.set(5, (Object)ItemStack.f_41583_);
        this.remainingBrewTime = 0;
        this.m_6596_();
    }

    private void showPreview(BrewingRecipe recipe) {
        this.items.set(5, (Object)recipe.assemble(this));
        this.remainingBrewTime = recipe.getBrewingTime();
        this.m_6596_();
    }

    @Override
    @Nonnull
    public List<ItemStack> getIngredients() {
        NonNullList sample = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        for (int i = 0; i < 4; ++i) {
            sample.set(i, (Object)((ItemStack)this.items.get(i)).m_41777_());
        }
        return sample;
    }

    @Override
    @Nonnull
    public ItemStack getCup() {
        return ((ItemStack)this.items.get(4)).m_41777_();
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128376_("RemainingBrewTime", (short)this.remainingBrewTime);
        tag.m_128376_("statusCode", (short)this.statusCode);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.remainingBrewTime = tag.m_128448_("RemainingBrewTime");
        this.statusCode = tag.m_128448_("statusCode");
    }

    public Component m_5446_() {
        return new TranslatableComponent("block.drinkbeer.beer_barrel");
    }

    protected Component m_6820_() {
        return new TranslatableComponent("block.drinkbeer.beer_barrel");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new BeerBarrelContainer(id, this, this.syncData, inventory, this);
    }

    protected AbstractContainerMenu m_6555_(int p_58627_, Inventory p_58628_) {
        return null;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128376_("RemainingBrewTime", (short)this.remainingBrewTime);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.remainingBrewTime = tag.m_128448_("RemainingBrewTime");
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int p_70301_1_) {
        return p_70301_1_ >= 0 && p_70301_1_ < this.items.size() ? (ItemStack)this.items.get(p_70301_1_) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int p_70298_1_, int p_70298_2_) {
        return ContainerHelper.m_18969_(this.items, (int)p_70298_1_, (int)p_70298_2_);
    }

    public ItemStack m_8016_(int p_70304_1_) {
        return ContainerHelper.m_18966_(this.items, (int)p_70304_1_);
    }

    public void m_6836_(int p_70299_1_, ItemStack p_70299_2_) {
        if (p_70299_1_ >= 0 && p_70299_1_ < this.items.size()) {
            this.items.set(p_70299_1_, (Object)p_70299_2_);
        }
    }

    public int m_6893_() {
        return IBrewingInventory.super.m_6893_();
    }

    public boolean m_6542_(Player p_70300_1_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(p_70300_1_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public void m_6211_() {
        this.items.clear();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.itemHandler).cast();
        }
        return super.getCapability(cap, side);
    }
}

