/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.blockentities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lekavar.lma.drinkbeer.gui.BartendingTableContainer;
import lekavar.lma.drinkbeer.items.BeerBlockItem;
import lekavar.lma.drinkbeer.items.BeerMugItem;
import lekavar.lma.drinkbeer.items.MixedBeerBlockItem;
import lekavar.lma.drinkbeer.managers.MixedBeerManager;
import lekavar.lma.drinkbeer.registries.BlockEntityRegistry;
import lekavar.lma.drinkbeer.utils.ItemStackHelper;
import lekavar.lma.drinkbeer.utils.beer.Beers;
import lekavar.lma.drinkbeer.utils.mixedbeer.Spices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BartendingTableBlockEntity
extends BaseContainerBlockEntity {
    public static final int OUTPUT_SLOT_INDEX = 4;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private int beerId = 0;
    private int isMixedBeer = 0;
    private List<Integer> spiceList = new ArrayList<Integer>();
    private boolean[] usedSlots = new boolean[3];
    public final ContainerData syncData = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return BartendingTableBlockEntity.this.beerId;
                }
                case 1: {
                    return BartendingTableBlockEntity.this.isMixedBeer;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    BartendingTableBlockEntity.this.beerId = value;
                    break;
                }
                case 1: {
                    BartendingTableBlockEntity.this.isMixedBeer = value;
                }
            }
        }

        public int m_6499_() {
            return 1;
        }
    };

    public List<Integer> getBeerInputSpiceList() {
        ArrayList<Integer> inputSpiceList = new ArrayList<Integer>();
        ItemStack stack = this.getBeerInput();
        if (stack.m_41720_() instanceof MixedBeerBlockItem) {
            return MixedBeerManager.getSpiceList(stack);
        }
        return inputSpiceList;
    }

    public int getInputSpicesNum() {
        for (int i = 0; i < 3; ++i) {
            if (!((ItemStack)this.items.get(1 + i)).m_41619_()) continue;
            return i;
        }
        return 3;
    }

    private void resetUsedSlots() {
        Arrays.fill(this.usedSlots, false);
    }

    public void tickServer() {
        ItemStack resultStack;
        ItemStack input = (ItemStack)this.items.get(0);
        if (ItemStackHelper.isAirOrEmpty(input)) {
            this.items.set(4, (Object)ItemStack.f_41583_);
            this.m_6596_();
            return;
        }
        if (!(input.m_41720_() instanceof BeerBlockItem)) {
            resultStack = ItemStack.f_41583_;
        } else {
            this.resetUsedSlots();
            int beerId = this.getBeerInputBeerId();
            Item beer = input.m_41720_();
            boolean isInputMixedBeer = beer instanceof MixedBeerBlockItem;
            if (!isInputMixedBeer && this.getInputSpicesNum() == 0) {
                resultStack = new ItemStack((ItemLike)Beers.byId(beerId).getBeerItem(), 1);
            } else {
                ArrayList<Integer> oriSpiceList = new ArrayList<Integer>();
                oriSpiceList = isInputMixedBeer ? this.getBeerInputSpiceList() : oriSpiceList;
                for (int i = 0; i < 3; ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i + 1);
                    if (oriSpiceList.size() >= 3 || ItemStackHelper.isAirOrEmpty(stack)) continue;
                    if (i < oriSpiceList.size()) {
                        oriSpiceList.add(i, Spices.byItem(stack.m_41720_()).getId());
                    } else {
                        oriSpiceList.add(Spices.byItem(stack.m_41720_()).getId());
                    }
                    this.usedSlots[i] = true;
                }
                resultStack = MixedBeerManager.genMixedBeerItemStack(beerId, oriSpiceList);
            }
        }
        this.items.set(4, (Object)resultStack);
        this.m_6596_();
    }

    private ItemStack getBeerInput() {
        return (ItemStack)this.items.get(0);
    }

    private boolean isMixedBeer() {
        return this.getBeerInput().m_41720_() instanceof MixedBeerBlockItem;
    }

    private int getBeerInputBeerId() {
        if (this.isMixedBeer()) {
            return MixedBeerManager.getBeerId(this.getBeerInput());
        }
        return Beers.byItem(this.getBeerInput().m_41720_()).getId();
    }

    public void clearInputs() {
        ((ItemStack)this.items.get(0)).m_41774_(1);
        for (int i = 0; i < 3; ++i) {
            if (!this.usedSlots[i]) continue;
            ((ItemStack)this.items.get(i + 1)).m_41774_(1);
        }
        this.m_6596_();
    }

    public BartendingTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.BARTENDING_TABLE_TILEENTITY.get(), pos, state);
    }

    public Component m_5446_() {
        return new TranslatableComponent("block.drinkbeer.bartending_table_normal");
    }

    protected Component m_6820_() {
        return new TranslatableComponent("block.drinkbeer.bartending_table_normal");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new BartendingTableContainer(id, (Container)this, this.syncData, inventory, this);
    }

    protected AbstractContainerMenu m_6555_(int p_58627_, Inventory p_58628_) {
        return null;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128376_("beerId", (short)this.beerId);
        tag.m_128376_("isMixedBeer", (short)this.isMixedBeer);
        tag.m_128408_("spiceList", this.spiceList);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.beerId = tag.m_128448_("beerId");
        this.isMixedBeer = tag.m_128448_("isMixedBeer");
        for (int s : tag.m_128465_("spiceList")) {
            this.spiceList.add(s);
        }
    }

    public boolean setBeer(ItemStack beerItemStack) {
        try {
            Item beerItem = beerItemStack.m_41720_();
            if (beerItem instanceof BeerMugItem) {
                this.isMixedBeer = 0;
                this.beerId = Beers.byItem(beerItem).getId();
            } else if (beerItem instanceof MixedBeerBlockItem) {
                this.isMixedBeer = 1;
                this.beerId = MixedBeerManager.getBeerId(beerItemStack);
                this.spiceList = MixedBeerManager.getSpiceList(beerItemStack);
            }
            ItemStack oriBeerItemStack = this.isMixedBeer == 1 ? MixedBeerManager.genMixedBeerItemStack(this.beerId, this.spiceList) : new ItemStack((ItemLike)Beers.byId(this.beerId).getBeerItem(), 1);
            this.m_6836_(0, oriBeerItemStack);
            return true;
        }
        catch (Exception e) {
            System.out.println("Something wrong when reading beer properties in BartendingTableEntity");
            return false;
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128376_("beerId", (short)this.beerId);
        tag.m_128376_("isMixedBeer", (short)this.isMixedBeer);
        tag.m_128408_("spiceList", this.spiceList);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.spiceList.clear();
        for (int Spice : tag.m_128465_("spiceList")) {
            this.spiceList.add(Spice);
        }
        this.beerId = tag.m_128448_("beerId");
        this.isMixedBeer = tag.m_128448_("isMixedBeer");
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int p_18941_) {
        return p_18941_ >= 0 && p_18941_ < this.items.size() ? (ItemStack)this.items.get(p_18941_) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int p_18942_, int p_18943_) {
        return ContainerHelper.m_18969_(this.items, (int)p_18942_, (int)p_18943_);
    }

    public ItemStack m_8016_(int p_18951_) {
        return ContainerHelper.m_18966_(this.items, (int)p_18951_);
    }

    public void m_6836_(int p_18944_, ItemStack p_18945_) {
        if (p_18944_ >= 0 && p_18944_ < this.items.size()) {
            this.items.set(p_18944_, (Object)p_18945_);
        }
    }

    public boolean m_6542_(Player p_18946_) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(p_18946_.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public void m_6211_() {
        this.items.clear();
    }
}

